/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	CreateCircle.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "Cline.h"
#include "CApplication.h"

//	Creates a circle using the center point and radius
//	and returns the circle created
//	After creation the circle is AutoConstrained.

HRESULT CreateCircle(double centerX, double centerY, double radius, ILine **dCircle1)
{

	START_METHOD("CreateCircle")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// Get geometric interface
	IGeometric *geometric = CAST(IGeometric, activeWorkplane);

	// Get zPlane
	IGeometry *pGeometry = NULL;
	status = geometric->GetGeometry(&pGeometry);
	CHECK_RETURN_STATUS(status)

	IPlane *plane = CAST(IPlane, pGeometry);

	// Create centerVector
	IVector *centerVector2D = NULL;
	status = (GetCLASS(Vector))->CreateVector(centerX, centerY, 0, &centerVector2D);
	CHECK_RETURN_STATUS(status)

	// Get the 3D vector for centerVector
	IVector *centerVector3D = NULL;
	status = activeWorkplane->Get3DVector(centerVector2D, &centerVector3D);
	CHECK_RETURN_STATUS(status)

	// Get normal to the plane
	IDirection *normal = NULL;
	status = plane->GetNormal(&normal);
	CHECK_RETURN_STATUS(status)

	// Create basic circle
	IBasicCircle *basicCircle1 = NULL;
	status = (GetCLASS(BasicCircle))->CreateBasicCircle(centerVector3D, normal, radius, &basicCircle1);
	CHECK_RETURN_STATUS(status)

	// Create aLine object
	ILine *circle1 = NULL;
	status = activeSketch->CreateLine(CAST(ICurve, basicCircle1), &circle1);
	CHECK_RETURN_STATUS(status)
	*dCircle1 = circle1;

	// Apply AutoConstrain on the circle created
	status = activeWorkplane->AutoConstrain(CAST(IObjectOrSet, circle1));
	CHECK_RETURN_STATUS(status)

	// Set the selection to the circle created
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, circle1));
	CHECK_RETURN_STATUS(status)

	END_METHOD("CreateCircle")
}
